<?php
require __DIR__ . '/cors.php';
require __DIR__ . '/db.php';

$payload = json_input();
$email = $payload['email'] ?? '';
$password = $payload['password'] ?? '';

// Requer pgcrypto para comparar hashes (opção 1: usar password_hash no PHP e salvar)
// Aqui vamos assumir que a coluna profiles.password_hash usa password_hash() (bcrypt).
$stmt = $pdo->prepare('SELECT id, name, email, role, password_hash FROM public.profiles WHERE email = :email LIMIT 1');
$stmt->execute([':email' => $email]);
$user = $stmt->fetch();

if (!$user || empty($user['password_hash']) || !password_verify($password, $user['password_hash'])) {
  http_response_code(401);
  echo json_encode(['error' => 'Credenciais inválidas']);
  exit;
}

$token = base64_encode(json_encode([
  'uid' => $user['id'],
  'role' => $user['role'],
  'exp' => time() + 60 * 60 * 12
]));

echo json_encode([
  'token' => $token,
  'profile' => [
    'id' => $user['id'],
    'name' => $user['name'],
    'email' => $user['email'],
    'role' => $user['role']
  ]
]);
